<?php

class PxlImage_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_image';
    protected $title = 'BR Image';
    protected $icon = 'eicon-image';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"tab_content","label":"Content","tab":"content","controls":[{"name":"source_type","label":"Source Type","type":"select","options":{"s_img":"Select Image","f_img":"Featured Image"},"default":"s_img"},{"name":"image","label":"Choose Image","type":"media","condition":{"source_type":["s_img"]}},{"name":"image_link","label":"Link","type":"url"},{"name":"image_type","label":"Image Type","type":"select","options":{"img":"Image","bg":"Background"},"default":"img"},{"name":"img_size","label":"Image Size","type":"text","description":"Enter image size (Example: \"thumbnail\", \"medium\", \"large\", \"full\" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height).","condition":{"image_type":["img"]}},{"name":"image_align","label":"Image Alignment","type":"choose","control_type":"responsive","options":{"left":{"title":"Left","icon":"fa fa-align-left"},"center":{"title":"Center","icon":"fa fa-align-center"},"right":{"title":"Right","icon":"fa fa-align-right"}},"selectors":{"{{WRAPPER}} .pxl-image-single":"text-align: {{VALUE}};"}}]},{"name":"tab_style_img","label":"Image","tab":"style","controls":[{"name":"style-im","label":"Style","type":"select","options":{"df":"Default","block-blur":"Block Blur 1","block-blur2":"Block Blur 2","block-blur3":"Block Blur 3","block-blur4":"Block Blur 4","block-blur5":"Block Blur 5","block-blur6":"Block Blur 6","block-blur7":"Block Blur 7","block-blur8":"Block Blur 8","block-blur9":"Block Blur 9","block-blur10":"Block Blur 10","block-blur11":"Block Blur 11"},"default":"df"},{"name":"w_block","label":"Width Block","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-image-single .block":"width: {{SIZE}}{{UNIT}} !important;","{{WRAPPER}} .pxl-image-single .block-blur .block:nth-child(1),{{WRAPPER}} .pxl-image-single .block-blur3 .block:nth-child(1),{{WRAPPER}} .pxl-image-single .block-blur7 .block:nth-child(1)":"left: {{SIZE}}{{UNIT}} !important;","{{WRAPPER}} .pxl-image-single .block-blur .block:nth-child(2),{{WRAPPER}} .pxl-image-single .block-blur3 .block:nth-child(2),{{WRAPPER}} .pxl-image-single .block-blur7 .block:nth-child(2)":"bottom: {{SIZE}}{{UNIT}} !important;","{{WRAPPER}} .pxl-image-single .block-blur2 .block:nth-child(2),{{WRAPPER}} .pxl-image-single .block-blur10 .block:nth-child(2) ":"right: {{SIZE}}{{UNIT}} !important;","{{WRAPPER}} .pxl-image-single .block-blur4 .block:nth-child(2),{{WRAPPER}} .pxl-image-single .block-blur5 .block:nth-child(2) ":"right: {{SIZE}}{{UNIT}} !important;","{{WRAPPER}} .pxl-image-single .block-blur4 .block:nth-child(3),{{WRAPPER}} .pxl-image-single .block-blur5 .block:nth-child(3) ":"right: calc({{SIZE}}{{UNIT}} + {{SIZE}}{{UNIT}}) !important;","{{WRAPPER}} .pxl-image-single .block-blur4 .block:nth-child(5),{{WRAPPER}} .pxl-image-single .block-blur5 .block:nth-child(5) ":"right: {{SIZE}}{{UNIT}} !important;","{{WRAPPER}} .pxl-image-single .block-blur9 .block:nth-child(2)":"right: {{SIZE}}{{UNIT}} !important;","{{WRAPPER}} .pxl-image-single .block-blur8 .block:nth-child(2)":"left: {{SIZE}}{{UNIT}} !important;","{{WRAPPER}} .pxl-image-single .block-blur11 .block:nth-child(2)":"left: {{SIZE}}{{UNIT}} !important;","{{WRAPPER}} .pxl-image-single .block-blur11 .block:nth-child(3)":"left: calc({{SIZE}}{{UNIT}} + {{SIZE}}{{UNIT}}) !important;"},"condition":{"style-im!":["df"]}},{"name":"h_block","label":"Height Block","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-image-single .block":"height: {{SIZE}}{{UNIT}} !important;","{{WRAPPER}} .pxl-image-single .block-blur9 .block:nth-child(1)":"top: {{SIZE}}{{UNIT}} !important;","{{WRAPPER}} .pxl-image-single .block-blur8 .block:nth-child(2)":"bottom: {{SIZE}}{{UNIT}} !important;","{{WRAPPER}} .pxl-image-single .block-blur2 .block:nth-child(3),{{WRAPPER}} .pxl-image-single .block-blur10 .block:nth-child(3) ":"bottom: {{SIZE}}{{UNIT}} !important;","{{WRAPPER}} .pxl-image-single .block-blur4 .block:nth-child(4),{{WRAPPER}} .pxl-image-single .block-blur5 .block:nth-child(4) ":"bottom: {{SIZE}}{{UNIT}} !important;","{{WRAPPER}} .pxl-image-single .block-blur4 .block:nth-child(5),{{WRAPPER}} .pxl-image-single .block-blur5 .block:nth-child(5) ":"bottom: {{SIZE}}{{UNIT}} !important;","{{WRAPPER}} .pxl-image-single .block-blur4 .block:nth-child(6),{{WRAPPER}} .pxl-image-single .block-blur5 .block:nth-child(6) ":"bottom: calc({{SIZE}}{{UNIT}} + {{SIZE}}{{UNIT}}) !important;","{{WRAPPER}} .pxl-image-single .block-blur11 .block:nth-child(2)":"bottom: {{SIZE}}{{UNIT}} !important; height: calc({{SIZE}}{{UNIT}} \/ 2) !important;"},"condition":{"style-im!":["df"]}},{"name":"image_max_height","label":"Image Max Height","type":"slider","description":"Enter number.","condition":{"image_type":"img"},"range":{"px":{"min":0,"max":3000}},"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-image-single img":"max-height: {{SIZE}}{{UNIT}};"}},{"name":"image_width","label":"Image Width","type":"choose","options":{"auto":{"title":"Auto","icon":"fas fa-arrows-alt-v"},"100%":{"title":"Full","icon":"fas fa-arrows-alt-h"}},"selectors":{"{{WRAPPER}} .pxl-image-single img":"width: {{VALUE}};"},"condition":{"image_type":"img"},"control_type":"responsive"},{"name":"image_height","label":"Image Height","type":"slider","description":"Enter number.","condition":{"image_type":"bg"},"range":{"px":{"min":0,"max":3000}},"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-image-single .pxl-item--bg":"height: {{SIZE}}{{UNIT}};"}},{"name":"border_radius","label":"Border Radius","type":"dimensions","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-image-single img, {{WRAPPER}} .pxl-item--inner, {{WRAPPER}} .pxl-image-single .pxl-item--bg":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"border_type","label":"Border Type","type":"select","options":{"":"None","solid":"Solid","double":"Double","dotted":"Dotted","dashed":"Dashed","groove":"Groove"},"selectors":{"{{WRAPPER}} .pxl-image-single img":"border-style: {{VALUE}} !important;"}},{"name":"border_width","label":"Border Width","type":"dimensions","selectors":{"{{WRAPPER}} .pxl-image-single img":"border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;"},"condition":{"border_type!":""},"responsive":true},{"name":"border_color","label":"Border Color","type":"color","default":"","selectors":{"{{WRAPPER}} .pxl-image-single img":"border-color: {{VALUE}} !important;"},"condition":{"border_type!":""}},{"name":"box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-image-single img"},{"name":"img_effect","label":"Image Effect","type":"select","options":{"":"None","pxl-image-effect1":"Zigzag","pxl-image-tilt":"Tilt","pxl-image-spin":"Spin","pxl-image-zoom":"Zoom","pxl-image-bounce":"Bounce","slide-up-down":"Slide Up Down","slide-top-to-bottom":"Slide Top To Bottom ","pxl-image-effect2":"Slide Bottom To Top ","slide-right-to-left":"Slide Right To Left ","slide-left-to-right":"Slide Left To Right ","pxl-hover1":"ZoomIn","pxl-hover2":"ZoomOut","rotate-z":"Rotate Z","pxl-animation-round":"Round","pxl-image-parallax":"Parallax Hover","pxl-parallax-scroll":"Parallax Scroll"},"default":"","condition":{"image_type":"img"}},{"name":"parallax_scroll_type","label":"Parallax Scroll Type","type":"select","options":{"y":"Effect Y","x":"Effect X","z":"Effect Z"},"default":"y","condition":{"img_effect":"pxl-parallax-scroll"}},{"name":"parallax_scroll_value_x","label":"Parallax Value","type":"text","condition":{"img_effect":"pxl-parallax-scroll"},"default":"80","description":"Enter number."},{"name":"parallax_value","label":"Parallax Value","type":"text","condition":{"img_effect":"pxl-image-parallax"},"default":"40","description":"Enter number."},{"name":"max_tilt","label":"Max Tilt","type":"text","condition":{"img_effect":"pxl-image-tilt"},"default":"10","description":"Enter number."},{"name":"speed_tilt","label":"Speed Tilt","type":"text","condition":{"img_effect":"pxl-image-tilt"},"default":"400","description":"Enter number."},{"name":"perspective_tilt","label":"Perspective Tilt","type":"text","condition":{"img_effect":"pxl-image-tilt"},"default":"1000","description":"Enter number."},{"name":"speed_effect","label":"Speed","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":100000}},"selectors":{"{{WRAPPER}} .pxl-image-single, {{WRAPPER}} .pxl-image-single img":"animation-duration: {{SIZE}}ms;"},"condition":{"img_effect!":["pxl-image-tilt","pxl-hover1","pxl-parallax-scroll"]},"description":"Enter number, unit is ms."},{"name":"img_display","label":"Hide on Screen &lt;= 1400px","type":"switcher","default":false},{"name":"hide_parallax_sm","label":"Disable Parallax on Mobile &lt;= 767px","type":"switcher","default":false,"condition":{"img_effect":["pxl-parallax-scroll"]}}]},{"name":"section_animation","label":"Animation","tab":"style","condition":[],"controls":[{"name":"pxl_animate","label":"Bravis Animate","type":"select","options":{"":"None","wow bounce":"bounce","wow flash":"flash","wow pulse":"pulse","wow rubberBand":"rubberBand","wow shake":"shake","wow swing":"swing","wow tada":"tada","wow wobble":"wobble","wow bounceIn":"bounceIn","wow bounceInDown":"bounceInDown","wow bounceInLeft":"bounceInLeft","wow bounceInRight":"bounceInRight","wow bounceInUp":"bounceInUp","wow bounceOut":"bounceOut","wow bounceOutDown":"bounceOutDown","wow bounceOutLeft":"bounceOutLeft","wow bounceOutRight":"bounceOutRight","wow bounceOutUp":"bounceOutUp","wow fadeIn":"fadeIn","wow fadeInDown":"fadeInDown","wow fadeInDownBig":"fadeInDownBig","wow fadeInLeft":"fadeInLeft","wow fadeInLeftBig":"fadeInLeftBig","wow fadeInRight":"fadeInRight","wow fadeInRightBig":"fadeInRightBig","wow fadeInUp":"fadeInUp","wow fadeInUpBig":"fadeInUpBig","wow fadeOut":"fadeOut","wow fadeOutDown":"fadeOutDown","wow fadeOutDownBig":"fadeOutDownBig","wow fadeOutLeft":"fadeOutLeft","wow fadeOutLeftBig":"fadeOutLeftBig","wow fadeOutRight":"fadeOutRight","wow fadeOutRightBig":"fadeOutRightBig","wow fadeOutUp":"fadeOutUp","wow fadeOutUpBig":"fadeOutUpBig","wow flip":"flip","wow flipCase":"flipCase","wow flipInX":"flipInX","wow flipInY":"flipInY","wow flipOutX":"flipOutX","wow flipOutY":"flipOutY","wow lightSpeedIn":"lightSpeedIn","wow lightSpeedOut":"lightSpeedOut","wow rotateIn":"rotateIn","wow rotateInDownLeft":"rotateInDownLeft","wow rotateInDownRight":"rotateInDownRight","wow rotateInUpLeft":"rotateInUpLeft","wow rotateInUpRight":"rotateInUpRight","wow rotateOut":"rotateOut","wow rotateOutDownLeft":"rotateOutDownLeft","wow rotateOutDownRight":"rotateOutDownRight","wow rotateOutUpLeft":"rotateOutUpLeft","wow rotateOutUpRight":"rotateOutUpRight","wow hinge":"hinge","wow rollIn":"rollIn","wow rollOut":"rollOut","wow zoomInSmall":"zoomInSmall","wow zoomIn":"zoomInBig","wow zoomOut":"zoomOut","wow skewIn":"skewInLeft","wow skewInRight":"skewInRight","wow skewInBottom":"skewInBottom","wow RotatingY":"RotatingY","wow PXLfadeInUp":"PXLfadeInUp","fadeInPopup":"fadeInPopup","pxl-split-text split-in-fade":"Slip Text In Fade","pxl-split-text split-in-right":"Slip Text In Right","pxl-split-text split-in-left":"Slip Text In Left","pxl-split-text split-in-up":"Slip Text In Up","pxl-split-text split-in-down":"Slip Text In Down","pxl-split-text split-in-rotate":"Slip Text In Rotate","pxl-split-text split-in-scale":"Slip Text In Scale","pxl-split-text split-words-scale":"Words Scale","pxl-split-text split-lines-transform":"Lines Transform","pxl-split-text split-lines-rotation-x":"Lines Transform rotate rotate"},"default":""},{"name":"pxl_animate_delay","label":"Animate Delay","type":"text","default":"0","description":"Enter number. Default 0ms"}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'tilt','pxl-tweenmax' );
}