<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_social_icon',
        'title' => esc_html__('BR Social Icons', 'herrington'),
        'icon' => 'eicon-social-icons',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'herrington'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'icons',
                            'label' => esc_html__('Social Icons', 'herrington'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'pxl_icon',
                                    'label' => esc_html__('Icon', 'herrington' ),
                                    'type' => \Elementor\Controls_Manager::ICONS,
                                    'fa4compatibility' => 'icon',
                                    'recommended' => [
                                    'fa-brands' => [
                                        'android',
                                        'apple',
                                        'behance',
                                        'bitbucket',
                                        'codepen',
                                        'delicious',
                                        'deviantart',
                                        'digg',
                                        'dribbble',
                                        'elementor',
                                        'facebook',
                                        'flickr',
                                        'foursquare',
                                        'free-code-camp',
                                        'github',
                                        'gitlab',
                                        'globe',
                                        'houzz',
                                        'instagram',
                                        'jsfiddle',
                                        'linkedin',
                                        'medium',
                                        'meetup',
                                        'mix',
                                        'mixcloud',
                                        'odnoklassniki',
                                        'pinterest',
                                        'product-hunt',
                                        'reddit',
                                        'shopping-cart',
                                        'skype',
                                        'slideshare',
                                        'snapchat',
                                        'soundcloud',
                                        'spotify',
                                        'stack-overflow',
                                        'steam',
                                        'telegram',
                                        'thumb-tack',
                                        'tripadvisor',
                                        'tumblr',
                                        'twitch',
                                        'twitter',
                                        'viber',
                                        'vimeo',
                                        'vk',
                                        'weibo',
                                        'weixin',
                                        'whatsapp',
                                        'wordpress',
                                        'xing',
                                        'yelp',
                                        'youtube',
                                        '500px',
                                    ],
                                    'fa-solid' => [
                                        'envelope',
                                        'link',
                                        'rss',
                                    ],
                                ],
                                ),
                                array(
                                    'name' => 'icon_link',
                                    'label' => esc_html__('Link', 'herrington'),
                                    'type' => \Elementor\Controls_Manager::URL,
                                    'label_block' => true,
                                ),
                                array(
                                    'name' => 'label',
                                    'label' => esc_html__('Label', 'herrington'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                            ),
                            'title_field' => '{{{ label }}}',
                        ),
                    ),
                ),
                
                array(
                    'name' => 'section_style',
                    'label' => esc_html__('Style', 'herrington'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'color',
                            'label' => esc_html__( 'Color', 'herrington' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-social-icons a' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'color_hover',
                            'label' => esc_html__( 'Color Hover', 'herrington' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-social-icons a:hover' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'margin',
                            'label' => esc_html__('Margin', 'herrington' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-social-icons a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                '{{WRAPPER}} .pxl-social-icons' => 'margin-left: -{{LEFT}}{{UNIT}};margin-right: -{{RIGHT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                    ),
                ),
                herrington_widget_animation_settings(),
            ),
        ),
    ),
    herrington_get_class_widget_path()
);