<?php
/**
 * Include the TGM_Plugin_Activation class.
 */
get_template_part( 'inc/admin/libs/tgmpa/class-tgm-plugin-activation' );

add_action( 'tgmpa_register', 'herrington_register_required_plugins' );
function herrington_register_required_plugins() {
    include( locate_template( 'inc/admin/demo-data/demo-config.php' ) );
    $pxl_server_info = apply_filters( 'pxl_server_info', ['plugin_url' => 'https://api.bravisthemes.com/plugins/'] ) ; 
    $default_path = $pxl_server_info['plugin_url'];  
    $images = get_template_directory_uri() . '/inc/admin/assets/img/plugins'; 
    $plugins = array(

        array(
            'name'               => esc_html__('Redux Framework', 'herrington'),
            'slug'               => 'redux-framework',
            'required'           => true,
            'logo'        => $images . '/redux.png',
            'description' => esc_html__( 'Build theme options and post, page options for WordPress Theme.', 'herrington' ),
        ),

        array(
            'name'               => esc_html__('Elementor', 'herrington'),
            'slug'               => 'elementor',
            'required'           => true,
            'logo'        => $images . '/elementor.png',
            'description' => esc_html__( 'Introducing a WordPress website builder, with no limits of design. A website builder that delivers high-end page designs and advanced capabilities', 'herrington' ),
        ),  

        array(
            'name'               => esc_html__('Bravis Addons', 'herrington'),
            'slug'               => 'bravis-addons',
            'source'             => 'bravis-addons.zip',
            'required'           => true,
            'logo'        => $images . '/bravis-logo.png',
            'description' => esc_html__( 'Main process and Powerful Elements Plugin, exclusively for Farmas WordPress Theme.', 'herrington' ),
        ),
        array(
            'name'               => esc_html__('Bravis User', 'herrington'),
            'slug'               => 'bravis-user',
            'source'             => 'bravis-user.zip',
            'required'           => true,
            'logo'        => $images . '/bravis-user.png',
            'description' => esc_html__( 'Plugin used for login widget.', 'herrington' ),
        ),
        array(
            'name'               => esc_html__('Contact Form 7', 'herrington'),
            'slug'               => 'contact-form-7',
            'required'           => true,
            'logo'        => $images . '/contact-f7.png',
            'description' => esc_html__( 'Contact Form 7 can manage multiple contact forms, you can customize the form and the mail contents flexibly with simple markup', 'herrington' ),
        ),

        array(
            'name'               => esc_html__('Contact Form 7 Multi Step', 'herrington'),
            'slug'               => 'cf7-multi-step',
            'required'           => true,
            'logo'        => $images . '/contact-f7-mt.png',
            'description' => esc_html__( 'Addons Multi Step For CTF7', 'herrington' ),
        ),
        
        array(
            'name'               => esc_html__('Revolution Slider', 'herrington'),
            'slug'               => 'revslider',
            'source'             => 'revslider.zip',
            'required'           => false,
            'logo'        => $images . '/rev-slider.png',
            'description' => esc_html__( 'Revolution Slider helps beginner-and mid-level designers WOW their clients with pro-level visuals.', 'herrington' )
        ),
        array(
            'name'               => esc_html__('Addons Contact Form 7', 'herrington'),
            'slug'               => 'ultimate-addons-for-contact-form-7',
            'required'           => false,
            'logo'        => $images . '/addons-ctf7.png',
            'description' => esc_html__( 'Support CTF7', 'herrington' )
        ), 
        array(
            'name'               => esc_html__('WooCommerce', 'herrington'),
            'slug'               => "woocommerce",
            'required'           => true,
            'logo'        => $images . '/woo.png',
            'description' => esc_html__( 'WooCommerce is the world’s most popular open-source eCommerce solution.', 'herrington' ),
        ),
        array(
            'name'               => esc_html__('WooCommerce Wishlist', 'herrington'),
            'slug'               => "woo-smart-wishlist",
            'required'           => false,
            'logo'        => $images . '/woo-smart-wishlist.png',
            'description' => esc_html__( 'WPC Smart Wishlist is a simple but powerful tool that can help your customer save products for buying later.', 'herrington' ),
        ),
    );
    $config = array(
        'default_path' => $default_path,           // Default absolute path to pre-packaged plugins.
        'menu'         => 'tgmpa-install-plugins', // Menu slug.
        'is_automatic' => true,
    );

    tgmpa( $plugins, $config );
}