<?php

class PxlHeading_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_heading';
    protected $title = 'BR Heading';
    protected $icon = 'eicon-heading';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"section_content","label":"Content","tab":"content","controls":[{"name":"source_type","label":"Source Type","type":"select","options":{"text":"Text","title":"Page Title"},"default":"text"},{"name":"sub_title","label":"Sub Title","type":"text","label_block":true},{"name":"title","label":"Title","type":"textarea","label_block":true,"condition":{"source_type":["text"]},"description":"Create Typewriter text width shortcode: [typewriter text=\"Text1, Text2\"] and Highlight text with shortcode: [highlight text=\"Text\"]"},{"name":"align","label":"Alignment","type":"choose","control_type":"responsive","options":{"left":{"title":"Left","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"right":{"title":"Right","icon":"eicon-text-align-right"},"justify":{"title":"Justified","icon":"eicon-text-align-justify"}},"selectors":{"{{WRAPPER}} .pxl-heading":"text-align: {{VALUE}};"}},{"name":"h_width","label":"Max Width","type":"slider","control_type":"responsive","size_units":["px","%"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-heading .pxl-heading--inner":"max-width: {{SIZE}}{{UNIT}};"}}]},{"name":"section_style_title","label":"Title","tab":"style","controls":[{"name":"title_tag","label":"HTML Tag","type":"select","options":{"h1":"H1","h2":"H2","h3":"H3","h4":"H4","h5":"H5","h6":"H6","div":"div","span":"span","p":"p"},"default":"h3"},{"name":"title_color","label":"Title Color","type":"color","selectors":{"{{WRAPPER}} .pxl-heading .pxl-item--title":"color: {{VALUE}};-webkit-text-stroke-color:{{VALUE}};","{{WRAPPER}} .pxl-heading .pxl-item--title.style-outline .pxl-text-line-backdrop svg":"stroke:{{VALUE}};"}},{"name":"title_typography","label":"Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-heading .pxl-item--title"},{"name":"custom_font","label":"Custom Font Family","type":"select","options":{"":"Default","ft-gt":"GT Walsheim Pro"},"default":""},{"name":"title_box_shadow","label":"Title Shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-heading .pxl-item--title"},{"name":"title_space_bottom","label":"Bottom Spacer","type":"slider","control_type":"responsive","size_units":["px"],"default":{"size":0},"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-heading .pxl-item--title":"margin-bottom: {{SIZE}}{{UNIT}};"},"separator":"after"},{"name":"h_title_style","label":"Style","type":"select","options":{"style-default":"Default","style-outline":"Outline"},"default":"style-default"},{"name":"pxl_animate","label":"Bravis Animate","type":"select","options":{"":"None","wow bounce":"bounce","wow flash":"flash","wow pulse":"pulse","wow rubberBand":"rubberBand","wow shake":"shake","wow swing":"swing","wow tada":"tada","wow wobble":"wobble","wow bounceIn":"bounceIn","wow bounceInDown":"bounceInDown","wow bounceInLeft":"bounceInLeft","wow bounceInRight":"bounceInRight","wow bounceInUp":"bounceInUp","wow bounceOut":"bounceOut","wow bounceOutDown":"bounceOutDown","wow bounceOutLeft":"bounceOutLeft","wow bounceOutRight":"bounceOutRight","wow bounceOutUp":"bounceOutUp","wow fadeIn":"fadeIn","wow fadeInDown":"fadeInDown","wow fadeInDownBig":"fadeInDownBig","wow fadeInLeft":"fadeInLeft","wow fadeInLeftBig":"fadeInLeftBig","wow fadeInRight":"fadeInRight","wow fadeInRightBig":"fadeInRightBig","wow fadeInUp":"fadeInUp","wow fadeInUpBig":"fadeInUpBig","wow fadeOut":"fadeOut","wow fadeOutDown":"fadeOutDown","wow fadeOutDownBig":"fadeOutDownBig","wow fadeOutLeft":"fadeOutLeft","wow fadeOutLeftBig":"fadeOutLeftBig","wow fadeOutRight":"fadeOutRight","wow fadeOutRightBig":"fadeOutRightBig","wow fadeOutUp":"fadeOutUp","wow fadeOutUpBig":"fadeOutUpBig","wow flip":"flip","wow flipCase":"flipCase","wow flipInX":"flipInX","wow flipInY":"flipInY","wow flipOutX":"flipOutX","wow flipOutY":"flipOutY","wow lightSpeedIn":"lightSpeedIn","wow lightSpeedOut":"lightSpeedOut","wow rotateIn":"rotateIn","wow rotateInDownLeft":"rotateInDownLeft","wow rotateInDownRight":"rotateInDownRight","wow rotateInUpLeft":"rotateInUpLeft","wow rotateInUpRight":"rotateInUpRight","wow rotateOut":"rotateOut","wow rotateOutDownLeft":"rotateOutDownLeft","wow rotateOutDownRight":"rotateOutDownRight","wow rotateOutUpLeft":"rotateOutUpLeft","wow rotateOutUpRight":"rotateOutUpRight","wow hinge":"hinge","wow rollIn":"rollIn","wow rollOut":"rollOut","wow zoomInSmall":"zoomInSmall","wow zoomIn":"zoomInBig","wow zoomOut":"zoomOut","wow skewIn":"skewInLeft","wow skewInRight":"skewInRight","wow RotatingY":"RotatingY","wow PXLfadeInUp":"PXLfadeInUp","wow TextOutlineAnimation":"Text Outline Animation","pxl-split-text split-in-fade":"Slip Text In Fade","pxl-split-text split-in-right":"Slip Text In Right","pxl-split-text split-in-left":"Slip Text In Left","pxl-split-text split-in-up":"Slip Text In Up","pxl-split-text split-in-down":"Slip Text In Down","pxl-split-text split-in-rotate":"Slip Text In Rotate","pxl-split-text split-in-scale":"Slip Text In Scale","pxl-split-text split-words-scale":"Words Scale","pxl-split-text split-lines-transform":"Lines Transform","pxl-split-text split-lines-rotation-x":"Lines Transform rotate rotate","style-scroll-bg":"Scroll Text"},"default":""},{"name":"pxl_animate_delay","label":"Animate Delay","type":"text","default":"0","description":"Enter number. Default 0ms"}]},{"name":"section_style_title_sub","label":"Sub Title","tab":"style","controls":[{"name":"sub_title_style","label":"Style","type":"select","options":{"px-sub-title-default":"Default","style-2":"Box"},"default":"px-sub-title-default"},{"name":"sub_title_box_color","label":"Box Color","type":"color","selectors":{"{{WRAPPER}} .pxl-heading .pxl-item--subtitle .pxl-item--subtext":"background-color: {{VALUE}};"},"condition":{"sub_title_style!":"px-sub-title-default"}},{"name":"sub_title_padding","label":"Padding","type":"dimensions","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-heading .pxl-item--subtitle .pxl-item--subtext":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;"},"control_type":"responsive"},{"name":"sub_title_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-heading .pxl-item--subtitle":"color: {{VALUE}};"}},{"name":"sub_title_typography","label":"Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-heading .pxl-item--subtitle, {{WRAPPER}} .pxl-heading .pxl-item--subtitle span"},{"name":"sub_title_space_top","label":"Top Spacer","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-heading .pxl-item--subtitle":"top: {{SIZE}}{{UNIT}};"}},{"name":"sub_title_space_bottom","label":"Bottom Spacer","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-heading .pxl-item--subtitle":"margin-bottom: {{SIZE}}{{UNIT}};"}},{"name":"pxl_animate_sub","label":"Bravis Animate","type":"select","options":{"":"None","wow bounce":"bounce","wow flash":"flash","wow pulse":"pulse","wow rubberBand":"rubberBand","wow shake":"shake","wow swing":"swing","wow tada":"tada","wow wobble":"wobble","wow bounceIn":"bounceIn","wow bounceInDown":"bounceInDown","wow bounceInLeft":"bounceInLeft","wow bounceInRight":"bounceInRight","wow bounceInUp":"bounceInUp","wow bounceOut":"bounceOut","wow bounceOutDown":"bounceOutDown","wow bounceOutLeft":"bounceOutLeft","wow bounceOutRight":"bounceOutRight","wow bounceOutUp":"bounceOutUp","wow fadeIn":"fadeIn","wow fadeInDown":"fadeInDown","wow fadeInDownBig":"fadeInDownBig","wow fadeInLeft":"fadeInLeft","wow fadeInLeftBig":"fadeInLeftBig","wow fadeInRight":"fadeInRight","wow fadeInRightBig":"fadeInRightBig","wow fadeInUp":"fadeInUp","wow fadeInUpBig":"fadeInUpBig","wow fadeOut":"fadeOut","wow fadeOutDown":"fadeOutDown","wow fadeOutDownBig":"fadeOutDownBig","wow fadeOutLeft":"fadeOutLeft","wow fadeOutLeftBig":"fadeOutLeftBig","wow fadeOutRight":"fadeOutRight","wow fadeOutRightBig":"fadeOutRightBig","wow fadeOutUp":"fadeOutUp","wow fadeOutUpBig":"fadeOutUpBig","wow flip":"flip","wow flipCase":"flipCase","wow flipInX":"flipInX","wow flipInY":"flipInY","wow flipOutX":"flipOutX","wow flipOutY":"flipOutY","wow lightSpeedIn":"lightSpeedIn","wow lightSpeedOut":"lightSpeedOut","wow rotateIn":"rotateIn","wow rotateInDownLeft":"rotateInDownLeft","wow rotateInDownRight":"rotateInDownRight","wow rotateInUpLeft":"rotateInUpLeft","wow rotateInUpRight":"rotateInUpRight","wow rotateOut":"rotateOut","wow rotateOutDownLeft":"rotateOutDownLeft","wow rotateOutDownRight":"rotateOutDownRight","wow rotateOutUpLeft":"rotateOutUpLeft","wow rotateOutUpRight":"rotateOutUpRight","wow hinge":"hinge","wow rollIn":"rollIn","wow rollOut":"rollOut","wow zoomInSmall":"zoomInSmall","wow zoomIn":"zoomInBig","wow zoomOut":"zoomOut","wow skewIn":"skewInLeft","wow skewInRight":"skewInRight","wow RotatingY":"RotatingY","wow PXLfadeInUp":"PXLfadeInUp","wow TextOutlineAnimation":"Text Outline Animation","pxl-split-text split-in-fade":"Slip Text In Fade","pxl-split-text split-in-right":"Slip Text In Right","pxl-split-text split-in-left":"Slip Text In Left","pxl-split-text split-in-up":"Slip Text In Up","pxl-split-text split-in-down":"Slip Text In Down","pxl-split-text split-in-rotate":"Slip Text In Rotate","pxl-split-text split-in-scale":"Slip Text In Scale","pxl-split-text split-words-scale":"Words Scale","pxl-split-text split-lines-transform":"Lines Transform","pxl-split-text split-lines-rotation-x":"Lines Transform rotate rotate","style-scroll-bg":"Scroll Text"},"default":""},{"name":"pxl_animate_delay_sub","label":"Animate Delay","type":"text","default":"0","description":"Enter number. Default 0ms"}]},{"name":"section_style_highlight","label":"Highlight","tab":"style","controls":[{"name":"highlight_style","label":"Style","type":"select","options":{"highlight-default":"Default","highlight-text-gradient":"Text Gradient"},"default":"highlight-default"},{"name":"highlight_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-heading .pxl-title--highlight":"color: {{VALUE}};"},"condition":{"highlight_style":["highlight-default"]}},{"name":"highlight_color_from","label":"Color From","type":"color","selectors":{"{{WRAPPER}} .pxl-heading .pxl-title--highlight":"--gradient-color-from: {{VALUE}};"},"condition":{"highlight_style":["highlight-text-gradient"]}},{"name":"highlight_color_to","label":"Color To","type":"color","selectors":{"{{WRAPPER}} .pxl-heading .pxl-title--highlight":"--gradient-color-to: {{VALUE}};"},"condition":{"highlight_style":["highlight-text-gradient"]}},{"name":"highlight_typography","label":"Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-heading .pxl-title--highlight"},{"name":"highlight_text_image","label":"Text Image","type":"media","default":"","selectors":{"{{WRAPPER}} .pxl-heading .pxl-title--highlight":"background-image: url( {{URL}} );"}},{"name":"highlight_image_position","label":"Text Image Position","type":"select","options":{"":"Default","center center":"Center Center","center left":"Center Left","center right":"Center Right","top center":"Top Center","top left":"Top Left","top right":"Top Right","bottom center":"Bottom Center","bottom left":"Bottom Left","bottom right":"Bottom Right","initial":"Custom"},"default":"","selectors":{"{{WRAPPER}} .pxl-heading .pxl-title--highlight":"background-position: {{VALUE}};"},"condition":{"highlight_text_image[url]!":""}},{"name":"highlight_image_size","label":"Text Image Size","type":"select","hide_in_inner":true,"options":{"":"Default","auto":"Auto","cover":"Cover","contain":"Contain","initial":"Custom"},"default":"","selectors":{"{{WRAPPER}} .pxl-heading .pxl-title--highlight":"background-size: {{VALUE}};"},"condition":{"highlight_text_image[url]!":""}}]},{"name":"section_style_typewriter","label":"Typewriter","tab":"style","controls":[{"name":"typewriter_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-heading .pxl-title--typewriter":"color: {{VALUE}};"}},{"name":"typewriter_typography","label":"Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-heading .pxl-title--typewriter"}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'gsap','pxl-scroll-trigger','pxl-splitText' );
}