<?php

class PxlVideoPlayer_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_video_player';
    protected $title = 'BR Video Button';
    protected $icon = 'eicon-play';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"section_content","label":"Content","tab":"content","controls":[{"name":"video_link","label":"Link","type":"text","default":"https:\/\/www.youtube.com\/watch?v=SF4aHwxHtZ0"},{"name":"video_icon","label":"Video Icon","type":"icons","fa4compatibility":"icon"},{"name":"label","label":"Label","type":"text","default":""},{"name":"image_type","label":"Image Type","type":"select","options":{"none":"None","img":"Image","bg":"Background"},"default":"none"},{"name":"image","label":"Image","type":"media","condition":{"image_type":["img","bg"]}},{"name":"img_size","label":"Image Size","type":"text","description":"Enter image size (Example: \"thumbnail\", \"medium\", \"large\", \"full\" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height).","condition":{"image_type":"img"}},{"name":"img_border_radius","label":"Image Border Radius","type":"dimensions","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-video-player .pxl-video--imagebg, {{WRAPPER}} .pxl-video-player .pxl-video--holder img":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"condition":{"image_type":["img","bg"]}},{"name":"image_height","label":"Image Height","type":"slider","description":"Enter number.","condition":{"image_type":"bg"},"range":{"px":{"min":0,"max":3000}},"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-video-player .pxl-video--imagebg":"height: {{SIZE}}{{UNIT}};"}},{"name":"box_style","label":"Box Style","type":"select","options":{"box-normal":"Normal","box-gradient":"Gradient"},"default":"box-normal","condition":{"image_type":["img","bg"]}},{"name":"btn_video_style","label":"Button Video Style","type":"select","options":{"style1":"Style White","style-blur":"Style Blur","style-outline":"Style Outline","style-outline-2":"Style Outline 2","style-icon":"Style Icon"},"default":"style1"},{"name":"btn_video_position","label":"Button Video Position","type":"select","options":{"p-center":"Center","p-top-left":"Top Left","p-top-right":"Top Right","p-bottom-left":"Bottom Left","p-bottom-right":"Bottom Right"},"default":"p-center","condition":{"image_type":["img","bg"]}},{"name":"top_positioon","label":"Top Position","type":"slider","size_units":["px","%"],"control_type":"responsive","default":{"size":0,"unit":"%"},"range":{"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-top-left, {{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-top-right":"top: {{SIZE}}{{UNIT}};"},"condition":{"btn_video_position":["p-top-left","p-top-right"]}},{"name":"right_positioon","label":"Right Position","type":"slider","size_units":["px","%"],"control_type":"responsive","default":{"size":0,"unit":"%"},"range":{"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-top-right, {{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-bottom-right":"right: {{SIZE}}{{UNIT}};"},"condition":{"btn_video_position":["p-top-right","p-bottom-right"]}},{"name":"bottom_positioon","label":"Bottom Position","type":"slider","size_units":["px","%"],"control_type":"responsive","default":{"size":0,"unit":"%"},"range":{"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-bottom-left, {{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-bottom-right":"bottom: {{SIZE}}{{UNIT}};"},"condition":{"btn_video_position":["p-bottom-left","p-bottom-right"]}},{"name":"left_positioon","label":"Left Position","type":"slider","size_units":["px","%"],"control_type":"responsive","default":{"size":0,"unit":"%"},"range":{"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-top-left, {{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-bottom-left":"left: {{SIZE}}{{UNIT}};"},"condition":{"btn_video_position":["p-top-left","p-bottom-left"]}}]},{"name":"section_style_general","label":"General","tab":"style","controls":[{"name":"button_size","label":"Button Size","type":"slider","description":"Enter number.","range":{"px":{"min":0,"max":3000}},"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-video-player .pxl-btn-video":"height: {{SIZE}}{{UNIT}};width: {{SIZE}}{{UNIT}};"}},{"name":"ic_border_radius","label":"Icon Border Radius","type":"dimensions","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-video-player .pxl-btn-video":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-video-player .pxl-btn-video i":"color: {{VALUE}};","{{WRAPPER}} .pxl-video-player .pxl-btn-video svg":"fill: {{VALUE}};"}},{"name":"color_hv","label":"Hover Color","type":"color","selectors":{"{{WRAPPER}} .pxl-video-player .pxl-btn-video:hover i":"color: {{VALUE}};"}},{"name":"bgcolor","label":"Background Icon Color","type":"color","selectors":{"{{WRAPPER}} .pxl-video-player .pxl-btn-video":"background-color: {{VALUE}};","{{WRAPPER}} .pxl-video-player .pxl-btn-video:hover":"border-color: {{VALUE}};"}},{"name":"bgcolor_hv","label":"Background Icon Hover Color","type":"color","selectors":{"{{WRAPPER}} .pxl-video-player .pxl-btn-video:hover":"background-color: {{VALUE}};"}},{"name":"icon_size","label":"Icon Font Size","type":"slider","description":"Enter number.","range":{"px":{"min":0,"max":3000}},"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-video-player i":"font-size: {{SIZE}}{{UNIT}};"}},{"name":"t_width","label":"Max Width","type":"slider","control_type":"responsive","size_units":["px","%"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-video-player .pxl-video--inner":"max-width: {{SIZE}}{{UNIT}};"}}]},{"name":"section_style_lb","label":"Label","tab":"style","controls":[{"name":"lb_typography","label":"Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-video-player .label-text"},{"name":"lb_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-video-player .label-text":"color: {{VALUE}};"}}]},{"name":"section_animation","label":"Animation","tab":"style","condition":[],"controls":[{"name":"pxl_animate","label":"Bravis Animate","type":"select","options":{"":"None","wow bounce":"bounce","wow flash":"flash","wow pulse":"pulse","wow rubberBand":"rubberBand","wow shake":"shake","wow swing":"swing","wow tada":"tada","wow wobble":"wobble","wow bounceIn":"bounceIn","wow bounceInDown":"bounceInDown","wow bounceInLeft":"bounceInLeft","wow bounceInRight":"bounceInRight","wow bounceInUp":"bounceInUp","wow bounceOut":"bounceOut","wow bounceOutDown":"bounceOutDown","wow bounceOutLeft":"bounceOutLeft","wow bounceOutRight":"bounceOutRight","wow bounceOutUp":"bounceOutUp","wow fadeIn":"fadeIn","wow fadeInDown":"fadeInDown","wow fadeInDownBig":"fadeInDownBig","wow fadeInLeft":"fadeInLeft","wow fadeInLeftBig":"fadeInLeftBig","wow fadeInRight":"fadeInRight","wow fadeInRightBig":"fadeInRightBig","wow fadeInUp":"fadeInUp","wow fadeInUpBig":"fadeInUpBig","wow fadeOut":"fadeOut","wow fadeOutDown":"fadeOutDown","wow fadeOutDownBig":"fadeOutDownBig","wow fadeOutLeft":"fadeOutLeft","wow fadeOutLeftBig":"fadeOutLeftBig","wow fadeOutRight":"fadeOutRight","wow fadeOutRightBig":"fadeOutRightBig","wow fadeOutUp":"fadeOutUp","wow fadeOutUpBig":"fadeOutUpBig","wow flip":"flip","wow flipCase":"flipCase","wow flipInX":"flipInX","wow flipInY":"flipInY","wow flipOutX":"flipOutX","wow flipOutY":"flipOutY","wow lightSpeedIn":"lightSpeedIn","wow lightSpeedOut":"lightSpeedOut","wow rotateIn":"rotateIn","wow rotateInDownLeft":"rotateInDownLeft","wow rotateInDownRight":"rotateInDownRight","wow rotateInUpLeft":"rotateInUpLeft","wow rotateInUpRight":"rotateInUpRight","wow rotateOut":"rotateOut","wow rotateOutDownLeft":"rotateOutDownLeft","wow rotateOutDownRight":"rotateOutDownRight","wow rotateOutUpLeft":"rotateOutUpLeft","wow rotateOutUpRight":"rotateOutUpRight","wow hinge":"hinge","wow rollIn":"rollIn","wow rollOut":"rollOut","wow zoomInSmall":"zoomInSmall","wow zoomIn":"zoomInBig","wow zoomOut":"zoomOut","wow skewIn":"skewInLeft","wow skewInRight":"skewInRight","wow skewInBottom":"skewInBottom","wow RotatingY":"RotatingY","wow PXLfadeInUp":"PXLfadeInUp","fadeInPopup":"fadeInPopup","pxl-split-text split-in-fade":"Slip Text In Fade","pxl-split-text split-in-right":"Slip Text In Right","pxl-split-text split-in-left":"Slip Text In Left","pxl-split-text split-in-up":"Slip Text In Up","pxl-split-text split-in-down":"Slip Text In Down","pxl-split-text split-in-rotate":"Slip Text In Rotate","pxl-split-text split-in-scale":"Slip Text In Scale","pxl-split-text split-words-scale":"Words Scale","pxl-split-text split-lines-transform":"Lines Transform","pxl-split-text split-lines-rotation-x":"Lines Transform rotate rotate"},"default":""},{"name":"pxl_animate_delay","label":"Animate Delay","type":"text","default":"0","description":"Enter number. Default 0ms"}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'tilt' );
}